/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea;

import com.atlassian.clover.idea.IProjectPlugin;
import com.atlassian.clover.idea.ProjectPlugin;
import com.atlassian.clover.idea.build.ProjectRebuilder;
import com.atlassian.clover.idea.config.CloverModuleConfig;
import com.atlassian.clover.idea.config.CloverModuleConfigPanel;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleComponent;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="Clover", storages={@Storage(id="module", file="$MODULE_FILE$")})
public class CloverModuleComponent
implements ModuleComponent,
Configurable,
PersistentStateComponent<CloverModuleConfig> {
    private CloverModuleConfig config = new CloverModuleConfig();
    private CloverModuleConfigPanel configComponent;
    private final Project project;

    public CloverModuleComponent(Project project) {
        this.project = project;
    }

    @Nullable
    public static CloverModuleComponent getInstance(Module module) {
        return module == null ? null : (CloverModuleComponent)module.getComponent(CloverModuleComponent.class);
    }

    public CloverModuleConfig getConfig() {
        return this.config;
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    public void moduleAdded() {
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        return "Clover";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    @Nls
    public String getDisplayName() {
        return "Clover";
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return null;
    }

    public JComponent createComponent() {
        IProjectPlugin plugin = ProjectPlugin.getPlugin(this.project);
        if (plugin != null && plugin.isEnabled()) {
            this.configComponent = new CloverModuleConfigPanel();
            this.configComponent.setConfig(this.config);
            return this.configComponent;
        }
        JLabel msg = new JLabel("Clover plugin is disabled for current project");
        msg.setHorizontalAlignment(0);
        msg.setVerticalAlignment(1);
        msg.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        return msg;
    }

    public boolean isModified() {
        return this.configComponent != null && !this.config.equals(this.configComponent.getConfig());
    }

    public void apply() throws ConfigurationException {
        if (this.configComponent == null) {
            return;
        }
        CloverModuleConfig newConfig = this.configComponent.getConfig();
        boolean changed = !newConfig.equals(this.config);
        this.config = newConfig;
        if (changed) {
            ProjectRebuilder.getInstance(this.project).rebuildProject(newConfig.isExcluded());
        }
    }

    public void reset() {
        if (this.configComponent != null) {
            this.configComponent.setConfig(this.config);
        }
    }

    public void disposeUIResources() {
        this.configComponent = null;
    }

    public CloverModuleConfig getState() {
        return this.config;
    }

    public void loadState(CloverModuleConfig state) {
        this.config = new CloverModuleConfig(state);
    }
}

