/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.cfg.instr;

import com.atlassian.clover.Logger;
import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.cfg.instr.InstrumentationLevel;
import com.atlassian.clover.cfg.instr.MethodContextDef;
import com.atlassian.clover.cfg.instr.StatementContextDef;
import com.atlassian.clover.instr.tests.DefaultTestDetector;
import com.atlassian.clover.instr.tests.TestDetector;
import com.atlassian.clover.remote.DistributedConfig;
import com_atlassian_clover.CloverProfile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.openclover.util.Lists;

public class InstrumentationConfig
implements Serializable {
    public static final int DIRECTED_FLUSHING = 0;
    public static final int INTERVAL_FLUSHING = 1;
    public static final int THREADED_FLUSHING = 2;
    public static final String DIRECTED_FLUSH_POLICY = "directed";
    public static final String INTERVAL_FLUSH_POLICY = "interval";
    public static final String THREADED_FLUSH_POLICY = "threaded";
    public static final String[] FLUSH_VALUES = new String[]{"directed", "interval", "threaded"};
    public static final int DEFAULT_FLUSHING = 0;
    public static final String DEFAULT_DB_DIR = ".clover";
    public static final String DEFAULT_DB_FILE = "clover" + "4.5.0".replace('.', '_') + ".db";
    private boolean enabled = true;
    private int flushPolicy = 0;
    private boolean sliceRecording = true;
    private int flushInterval = 0;
    private boolean classInstrStrategy = true;
    private boolean reportInitErrors = true;
    private boolean recordTestResults = true;
    private int instrLevel = InstrumentationLevel.STATEMENT.ordinal();
    private Collection<File> includedFiles;
    private String initString;
    private String projectName = "";
    private File registryFile;
    private boolean relative;
    private String encoding;
    private File defaultBaseDir;
    private TestDetector testDetector;
    private File tmpDir;
    private List<MethodContextDef> methodContexts;
    private List<StatementContextDef> statementContexts;
    private List<CloverProfile> runtimeProfiles;
    private DistributedConfig distributedConfig;
    private String classNotFoundMsg;
    private String validationFailureReason;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isReportInitErrors() {
        return this.reportInitErrors;
    }

    public void setReportInitErrors(boolean reportInitErrors) {
        this.reportInitErrors = reportInitErrors;
    }

    public boolean isTestDetector() {
        return this.testDetector != null;
    }

    public TestDetector getTestDetector() {
        if (this.testDetector == null) {
            this.testDetector = new DefaultTestDetector();
        }
        return this.testDetector;
    }

    public void setTestDetector(TestDetector detector) {
        this.testDetector = detector;
    }

    public String getInitString() {
        return this.initString;
    }

    public boolean isRelative() {
        return this.relative;
    }

    public void setRelative(boolean relative) {
        this.relative = relative;
    }

    public int getFlushPolicy() {
        return this.flushPolicy;
    }

    public void setFlushPolicy(int flushPolicy) {
        this.flushPolicy = flushPolicy;
    }

    public void setFlushPolicyFromString(String fp) throws CloverException {
        int i = 0;
        while (i < FLUSH_VALUES.length) {
            if (FLUSH_VALUES[i].equalsIgnoreCase(fp)) {
                this.flushPolicy = i;
                return;
            }
            ++i;
        }
        throw new CloverException("Unknown flush policy \"" + fp + "\"");
    }

    public String getFlushPolicyString() {
        return FLUSH_VALUES[this.flushPolicy];
    }

    public boolean isClassInstrStrategy() {
        return this.classInstrStrategy;
    }

    public void setClassInstrStragegy(boolean useClass) {
        this.classInstrStrategy = useClass;
    }

    public void setInstrStrategy(String value) {
        if (value != null) {
            this.classInstrStrategy = value.equals("class");
        }
    }

    public File getRegistryFile() throws CloverException {
        return this.registryFile == null ? new File(this.getRuntimeInitString()) : this.registryFile;
    }

    public void setRegistryFile(File registryFile) {
        this.registryFile = registryFile;
    }

    public void setInitstring(String initstring) {
        this.initString = initstring;
    }

    public String getRuntimeInitString() throws CloverException {
        if (this.getInitString() == null) {
            this.createDefaultInitStringDir();
        }
        if (this.isRelative()) {
            return this.getInitString();
        }
        return this.resolveInitString();
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        if (projectName != null) {
            this.projectName = projectName;
        } else {
            Logger.getInstance().debug("Attempt to set the project name to null. Defaulting to '" + this.projectName + "'");
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isIntervalBasedFlushing() {
        return this.flushPolicy == 1 || this.flushPolicy == 2;
    }

    public boolean isSliceRecording() {
        return this.sliceRecording;
    }

    public void setSliceRecording(boolean sliceRecording) {
        this.sliceRecording = sliceRecording;
    }

    public int getFlushInterval() {
        return this.flushInterval;
    }

    public void setFlushInterval(int flushInterval) {
        this.flushInterval = flushInterval;
    }

    public File getDefaultBaseDir() {
        return this.defaultBaseDir == null ? new File("." + File.separator) : this.defaultBaseDir;
    }

    public void setDefaultBaseDir(File defaultBaseDir) {
        this.defaultBaseDir = defaultBaseDir;
    }

    public File getTmpDir() {
        return this.tmpDir;
    }

    public void setTmpDir(File tmpDir) {
        this.tmpDir = tmpDir;
    }

    public int getInstrLevel() {
        return this.instrLevel;
    }

    public void setInstrLevel(int instrLevel) {
        this.instrLevel = instrLevel;
    }

    public boolean isStatementInstrEnabled() {
        return this.instrLevel == InstrumentationLevel.STATEMENT.ordinal();
    }

    public void setInstrLevelStrategy(String value) {
        if (InstrumentationLevel.STATEMENT.name().equalsIgnoreCase(value)) {
            this.setInstrLevel(InstrumentationLevel.STATEMENT.ordinal());
        } else if (InstrumentationLevel.METHOD.name().equalsIgnoreCase(value)) {
            this.setInstrLevel(InstrumentationLevel.METHOD.ordinal());
        }
    }

    public String resolveInitString() {
        String resolvedInitString = this.getInitString();
        File initStringFile = new File(this.getDefaultBaseDir(), resolvedInitString);
        File initParent = initStringFile.getParentFile();
        if (initParent != null && initParent.exists()) {
            resolvedInitString = initStringFile.getAbsolutePath();
        }
        return resolvedInitString;
    }

    public String createDefaultInitStringDir() throws CloverException {
        File cloverDir = new File(this.getDefaultBaseDir(), DEFAULT_DB_DIR);
        if (cloverDir.exists() && !cloverDir.isDirectory() || !cloverDir.exists() && !cloverDir.mkdirs()) {
            throw new CloverException("Failed to create default Clover database '" + cloverDir + "'.");
        }
        this.setInitstring(String.valueOf(this.isRelative() ? cloverDir.getName() : cloverDir.getAbsolutePath()) + File.separatorChar + DEFAULT_DB_FILE);
        return this.getInitString();
    }

    public void setRecordTestResults(boolean recordTestResults) {
        this.recordTestResults = recordTestResults;
    }

    public boolean isRecordTestResults() {
        return this.recordTestResults;
    }

    public List<MethodContextDef> getMethodContexts() {
        return this.methodContexts;
    }

    public void addMethodContext(MethodContextDef context) {
        if (this.methodContexts == null) {
            this.methodContexts = Lists.newLinkedList();
        }
        this.methodContexts.add(context);
    }

    public List<StatementContextDef> getStatementContexts() {
        return this.statementContexts;
    }

    public void addStatementContext(StatementContextDef context) {
        if (this.statementContexts == null) {
            this.statementContexts = Lists.newLinkedList();
        }
        this.statementContexts.add(context);
    }

    public boolean hasCustomContexts() {
        return this.getMethodContexts() != null || this.getStatementContexts() != null;
    }

    public void setDistributedConfig(DistributedConfig distributedConfig) {
        this.distributedConfig = distributedConfig;
    }

    public String getDistributedConfigString() {
        return this.distributedConfig != null ? this.distributedConfig.toString() : null;
    }

    public String getClassNotFoundMsg() {
        return this.classNotFoundMsg;
    }

    public void setClassNotFoundMsg(String classNotFoundMsg) {
        this.classNotFoundMsg = classNotFoundMsg;
    }

    public Collection<File> getIncludedFiles() {
        return this.includedFiles;
    }

    public void setIncludedFiles(Collection<File> includedFiles) {
        this.includedFiles = includedFiles;
    }

    public void saveToFile(File file) throws IOException {
        Logger.getInstance().verbose("Saving instrumentation config to " + file.getAbsolutePath());
        Logger.getInstance().verbose("Files included for instrumentation: " + this.getIncludedFiles());
        FileOutputStream fos = new FileOutputStream(file);
        Throwable throwable = null;
        Object var4_5 = null;
        try (ObjectOutputStream oos = new ObjectOutputStream(fos);){
            oos.writeObject(this);
            oos.flush();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static InstrumentationConfig loadFromStream(InputStream stream) throws IOException, ClassNotFoundException {
        InstrumentationConfig config = null;
        try (ObjectInputStream ois = new ObjectInputStream(stream);){
            config = (InstrumentationConfig)ois.readObject();
        }
        Logger.getInstance().verbose("Files included for instrumentation: " + config.getIncludedFiles());
        return config;
    }

    public List<CloverProfile> getProfiles() {
        return this.runtimeProfiles;
    }

    public void addProfile(CloverProfile profile) {
        if (this.runtimeProfiles == null) {
            this.runtimeProfiles = Lists.newLinkedList();
        }
        this.runtimeProfiles.add(profile);
    }

    public boolean validate() {
        return true;
    }

    public String getValidationFailureReason() {
        return this.validationFailureReason;
    }

    protected void setValidationFailureReason(String reason) {
        this.validationFailureReason = reason;
    }
}

