/*
 * Decompiled with CFR 0.152.
 */
package clover.net.sf.jtreemap.swing;

import clover.net.sf.jtreemap.swing.SplitStrategy;
import clover.net.sf.jtreemap.swing.TreeMapNode;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplitBySlice
extends SplitStrategy {
    private static final long serialVersionUID = 8484486418097321160L;

    public static void splitInSlice(int x0, int y0, int w0, int h0, Vector<TreeMapNode> v, double sumWeight) {
        int offset = 0;
        boolean vertical = h0 > w0;
        for (TreeMapNode node : v) {
            if (vertical) {
                node.setX(x0);
                node.setWidth(w0);
                node.setY(y0 + offset);
                node.setHeight((int)Math.round((double)h0 * node.getWeight() / sumWeight));
                offset += node.getHeight();
                continue;
            }
            node.setX(x0 + offset);
            node.setWidth((int)Math.round((double)w0 * node.getWeight() / sumWeight));
            node.setY(y0);
            node.setHeight(h0);
            offset += node.getWidth();
        }
        if (!v.isEmpty()) {
            TreeMapNode node = v.lastElement();
            if (vertical && h0 != offset) {
                node.setHeight(node.getHeight() - offset + h0);
            } else if (!vertical && w0 != offset) {
                node.setWidth(node.getWidth() - offset + w0);
            }
        }
    }

    @Override
    public void splitElements(Vector<TreeMapNode> v, Vector<TreeMapNode> v1, Vector<TreeMapNode> v2) {
    }

    @Override
    protected void calculatePositionsRec(int x0, int y0, int w0, int h0, double weight0, Vector<TreeMapNode> v) {
        SplitBySlice.splitInSlice(x0, y0, w0, h0, v, weight0);
        for (TreeMapNode node : v) {
            if (node.isLeaf()) {
                node.setX(node.getX() + TreeMapNode.getBorder());
                node.setY(node.getY() + TreeMapNode.getBorder());
                node.setHeight(node.getHeight() - TreeMapNode.getBorder());
                node.setWidth(node.getWidth() - TreeMapNode.getBorder());
                continue;
            }
            if (TreeMapNode.getBorder() > 1) {
                TreeMapNode.setBorder(TreeMapNode.getBorder() - 2);
                this.calculatePositionsRec(node.getX() + 2, node.getY() + 2, node.getWidth() - 2, node.getHeight() - 2, node.getWeight(), node.getChildren());
                TreeMapNode.setBorder(TreeMapNode.getBorder() + 2);
                continue;
            }
            if (TreeMapNode.getBorder() == 1) {
                TreeMapNode.setBorder(0);
                this.calculatePositionsRec(node.getX() + 1, node.getY() + 1, node.getWidth() - 1, node.getHeight() - 1, node.getWeight(), node.getChildren());
                TreeMapNode.setBorder(1);
                continue;
            }
            this.calculatePositionsRec(node.getX(), node.getY(), node.getWidth(), node.getHeight(), node.getWeight(), node.getChildren());
        }
    }
}

