/*
 * Decompiled with CFR 0.152.
 */
package clover.net.sf.jtreemap.swing;

import clover.net.sf.jtreemap.swing.ColorProvider;
import clover.net.sf.jtreemap.swing.DefaultToolTipBuilder;
import clover.net.sf.jtreemap.swing.IToolTipBuilder;
import clover.net.sf.jtreemap.swing.SplitSquarified;
import clover.net.sf.jtreemap.swing.SplitStrategy;
import clover.net.sf.jtreemap.swing.TreeMapNode;
import clover.net.sf.jtreemap.swing.UniqueColorProvider;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.Serializable;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class JTreeMap
extends JComponent {
    private static final int BORDER_FOR_FONT = 5;
    private static final int MAX_NUM_CHAR = 3;
    private static final int INSET = 4;
    private static final int DISMISS_DELAY_MS = 100000;
    private static final long serialVersionUID = 7255952672238300249L;
    private static final Color TRANSPARENCY_COLOR = new Color(204, 204, 204, 128);
    private JTree treeView;
    private TreeMapNode activeLeaf = null;
    private ColorProvider colorProvider = null;
    private TreeMapNode displayedRoot = null;
    private TreeMapNode root = null;
    private SplitStrategy strategy = null;
    private IToolTipBuilder toolTipBuilder;
    private Zoom zoom;

    public JTreeMap(TreeMapNode root) {
        this(root, new SplitSquarified(), null, null, false);
    }

    public JTreeMap(TreeMapNode root, JTree treeView) {
        this(root, new SplitSquarified(), null, null, false);
        this.treeView = treeView;
    }

    public JTreeMap(TreeMapNode root, SplitStrategy strategy, JTree treeView, String weightPrefix, String valuePrefix, boolean showWeight) {
        this(root, strategy, weightPrefix, valuePrefix, showWeight);
        this.treeView = treeView;
    }

    public JTreeMap(TreeMapNode root, SplitStrategy strategy, String weightPrefix, String valuePrefix, boolean showWeight) {
        ToolTipManager ttm = ToolTipManager.sharedInstance();
        ttm.setInitialDelay(0);
        ttm.setReshowDelay(0);
        ttm.setDismissDelay(100000);
        ttm.setEnabled(true);
        ttm.setLightWeightPopupEnabled(true);
        this.setToolTipText("");
        this.toolTipBuilder = new DefaultToolTipBuilder(this, weightPrefix, valuePrefix, showWeight);
        this.zoom = new Zoom();
        this.setRoot(root);
        this.setStrategy(strategy);
        this.setColorProvider(new UniqueColorProvider());
        this.addMouseMotionListener(new HandleMouseMotion());
        this.addMouseListener(new HandleMouseClick());
    }

    public void calculatePositions() {
        if (this.getStrategy() != null && this.displayedRoot != null) {
            this.getStrategy().calculatePositions(this.displayedRoot);
        }
    }

    public JToolTip createToolTip() {
        return this.toolTipBuilder.getToolTip();
    }

    protected void draw(Graphics g, TreeMapNode item) {
        if (item.isLeaf() && item.getValue() != null) {
            g.setColor(this.colorProvider.getColor(item.getValue()));
            g.fillRect(item.getX(), item.getY(), item.getWidth(), item.getHeight());
        } else {
            Enumeration<TreeNode> e = item.children();
            while (e.hasMoreElements()) {
                this.draw(g, (TreeMapNode)e.nextElement());
            }
        }
    }

    protected void drawLabel(Graphics g, TreeMapNode item) {
        FontMetrics fm = g.getFontMetrics(g.getFont());
        if (fm.getHeight() < item.getHeight() - 2) {
            String label = item.getLabel();
            int y = (item.getHeight() + fm.getAscent() - fm.getDescent()) / 2;
            int stringWidth = fm.stringWidth(label);
            if (item.getWidth() - 5 <= stringWidth) {
                int nbChar = label.length() * item.getWidth() / stringWidth;
                label = nbChar > 3 ? label.substring(0, nbChar - 3) + "..." : "";
            }
            int x = (item.getWidth() - fm.stringWidth(label)) / 2;
            g.setColor(Color.black);
            g.drawString(label, item.getX() + x + 1, item.getY() + y + 1);
            g.drawString(label, item.getX() + x - 1, item.getY() + y + 1);
            g.drawString(label, item.getX() + x + 1, item.getY() + y - 1);
            g.drawString(label, item.getX() + x - 1, item.getY() + y - 1);
            g.drawString(label, item.getX() + x + 1, item.getY() + y);
            g.drawString(label, item.getX() + x - 1, item.getY() + y);
            g.drawString(label, item.getX() + x, item.getY() + y + 1);
            g.drawString(label, item.getX() + x, item.getY() + y - 1);
            g.setColor(Color.white);
            g.drawString(label, item.getX() + x, item.getY() + y);
        }
    }

    protected void drawLabels(Graphics g, TreeMapNode item) {
        g.setFont(this.getFont());
        if (this.displayedRoot.isLeaf()) {
            this.drawLabel(g, this.displayedRoot);
        } else {
            Enumeration<TreeNode> e = this.displayedRoot.children();
            while (e.hasMoreElements()) {
                this.drawLabel(g, (TreeMapNode)e.nextElement());
            }
        }
    }

    public TreeMapNode getActiveLeaf() {
        return this.activeLeaf;
    }

    public ColorProvider getColorProvider() {
        return this.colorProvider;
    }

    public TreeMapNode getDisplayedRoot() {
        return this.displayedRoot;
    }

    public TreeMapNode getRoot() {
        return this.root;
    }

    public SplitStrategy getStrategy() {
        return this.strategy;
    }

    public Point getToolTipLocation(MouseEvent event) {
        JToolTip toolTip = this.createToolTip();
        int xMax = this.displayedRoot.getX() + this.displayedRoot.getWidth();
        int yMin = this.displayedRoot.getY();
        if (this.activeLeaf != null) {
            int posY;
            int posX;
            if (this.activeLeaf.getWidth() >= toolTip.getWidth() + 8 && this.activeLeaf.getHeight() >= toolTip.getHeight() + 8) {
                posX = this.activeLeaf.getX() + 4;
                posY = this.activeLeaf.getY() + 4;
            } else {
                posX = this.activeLeaf.getX() + this.activeLeaf.getWidth() + 4;
                posY = this.activeLeaf.getY() - toolTip.getHeight() - 4;
            }
            if (posY < yMin + 4) {
                posY = yMin + 4;
            }
            if (posX + toolTip.getWidth() > xMax - 4 && this.activeLeaf.getX() >= toolTip.getWidth() + 4) {
                posX = this.activeLeaf.getX() - 4 - toolTip.getWidth();
            }
            return new Point(posX, posY);
        }
        return null;
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int width = this.getSize().width;
        int height = this.getSize().height;
        Insets insets = this.getInsets();
        int border = TreeMapNode.getBorder();
        this.root.setDimension(this.root.getX(), this.root.getY(), width - border - insets.left - insets.right, height - border - insets.top - insets.bottom);
        if (!this.root.equals(this.displayedRoot)) {
            this.displayedRoot.setDimension(this.displayedRoot.getX(), this.displayedRoot.getY(), width - border - insets.left - insets.right, height - border - insets.top - insets.bottom);
        }
        this.calculatePositions();
        if (this.displayedRoot.children().hasMoreElements()) {
            g.setColor(this.getBackground());
            g.fillRect(this.displayedRoot.getX(), this.displayedRoot.getY(), this.displayedRoot.getWidth() + border, this.displayedRoot.getHeight() + border);
            this.draw(g, this.displayedRoot);
            if (this.activeLeaf != null) {
                this.reveal(g, this.activeLeaf);
            }
            this.drawLabels(g, this.displayedRoot);
        }
    }

    protected void reveal(Graphics g, TreeMapNode item) {
        if (item.isLeaf()) {
            g.setColor(TRANSPARENCY_COLOR);
            g.fillRect(item.getX(), item.getY(), item.getWidth(), item.getHeight());
        }
    }

    public void setActiveLeaf(TreeMapNode newActiveLeaf) {
        if (newActiveLeaf == null || newActiveLeaf.isLeaf()) {
            this.activeLeaf = newActiveLeaf;
        }
    }

    public void setBorder(Border border) {
        Insets insets = this.getInsets();
        this.displayedRoot.setDimension(this.displayedRoot.getX() - insets.left, this.displayedRoot.getY() - insets.top, this.displayedRoot.getWidth() + insets.left + insets.right, this.displayedRoot.getHeight() + insets.top + insets.bottom);
        super.setBorder(border);
        insets = this.getInsets();
        this.displayedRoot.setDimension(this.displayedRoot.getX() + insets.left, this.displayedRoot.getY() + insets.top, this.displayedRoot.getWidth() - insets.left - insets.right, this.displayedRoot.getHeight() - insets.top - insets.bottom);
    }

    public void setColorProvider(ColorProvider newColorProvider) {
        this.colorProvider = newColorProvider;
    }

    public void setDisplayedRoot(TreeMapNode newDisplayedRoot) {
        this.displayedRoot = newDisplayedRoot;
    }

    public void setRoot(TreeMapNode newRoot) {
        this.root = newRoot;
        Insets insets = this.getInsets();
        this.root.setX(insets.left);
        this.root.setY(insets.top);
        this.setDisplayedRoot(this.root);
    }

    public void setStrategy(SplitStrategy newStrat) {
        this.strategy = newStrat;
    }

    public void setToolTipBuilder(IToolTipBuilder toolTipBuilder) {
        this.toolTipBuilder = toolTipBuilder;
    }

    public void setZoomKeepProportion(boolean keepProportion) {
        this.zoom.setKeepProportion(keepProportion);
    }

    public void unzoom() {
        this.zoom.undo();
    }

    public void zoom(TreeMapNode dest) {
        this.unzoom();
        this.zoom.execute(dest);
    }

    public JTree getTreeView() {
        return this.treeView;
    }

    public void setTreeView(JTree treeView) {
        this.treeView = treeView;
    }

    private class Zoom
    implements Serializable {
        private static final long serialVersionUID = 6708828099608367996L;
        private boolean enable = true;
        private boolean keepProportion = false;

        public void execute(TreeMapNode dest) {
            if (this.enable) {
                JTreeMap.this.setActiveLeaf(null);
                this.setNewDimension(dest);
                JTreeMap.this.setDisplayedRoot(dest);
                this.enable = false;
            }
        }

        public boolean isKeepProportion() {
            return this.keepProportion;
        }

        public void setKeepProportion(boolean keepProportion) {
            this.keepProportion = keepProportion;
        }

        protected void setNewDimension(TreeMapNode dest) {
            dest.setX(JTreeMap.this.getRoot().getX());
            dest.setY(JTreeMap.this.getRoot().getY());
            int rootWidth = JTreeMap.this.getRoot().getWidth();
            int rootHeight = JTreeMap.this.getRoot().getHeight();
            if (this.isKeepProportion()) {
                float divHeight;
                int destHeight = dest.getHeight();
                int destWidth = dest.getWidth();
                float divWidth = (float)destWidth / (float)rootWidth;
                if (divWidth >= (divHeight = (float)destHeight / (float)rootHeight)) {
                    dest.setHeight(Math.round((float)destHeight / divWidth));
                    dest.setWidth(rootWidth);
                } else {
                    dest.setHeight(rootHeight);
                    dest.setWidth(Math.round((float)destWidth / divHeight));
                }
            } else {
                dest.setHeight(rootHeight);
                dest.setWidth(rootWidth);
            }
        }

        public void undo() {
            if (!this.enable) {
                JTreeMap.this.setDisplayedRoot(JTreeMap.this.getRoot());
                this.enable = true;
            }
        }
    }

    protected class HandleMouseClick
    extends MouseAdapter {
        protected HandleMouseClick() {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 1 && e.getClickCount() == 1) {
                TreeMapNode t = JTreeMap.this.getDisplayedRoot().getChild(e.getX(), e.getY());
                if (t != null && !t.isLeaf()) {
                    if (JTreeMap.this.treeView == null) {
                        JTreeMap.this.zoom(t);
                    } else {
                        TreePath path = new TreePath(t.getPath());
                        JTreeMap.this.treeView.setSelectionPath(path);
                        JTreeMap.this.treeView.scrollPathToVisible(path);
                    }
                } else if (JTreeMap.this.treeView == null) {
                    JTreeMap.this.zoom((TreeMapNode)JTreeMap.this.getDisplayedRoot().getParent());
                } else {
                    TreePath path = new TreePath(((TreeMapNode)JTreeMap.this.getDisplayedRoot().getParent()).getPath());
                    JTreeMap.this.treeView.setSelectionPath(path);
                    JTreeMap.this.treeView.scrollPathToVisible(path);
                }
                JTreeMap.this.repaint();
            }
        }
    }

    protected class HandleMouseMotion
    extends MouseMotionAdapter {
        protected HandleMouseMotion() {
        }

        public void mouseMoved(MouseEvent e) {
            TreeMapNode t;
            if (JTreeMap.this.getDisplayedRoot().children().hasMoreElements() && (t = JTreeMap.this.getDisplayedRoot().getActiveLeaf(e.getX(), e.getY())) != null && !t.equals(JTreeMap.this.getActiveLeaf())) {
                JTreeMap.this.setActiveLeaf(t);
                JTreeMap.this.repaint();
            }
        }
    }
}

