/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.util;

import java.lang.reflect.Array;
import java.util.Locale;
import org.openclover.util.function.Function;

public class ArrayUtil {
    private ArrayUtil() {
    }

    public static String[] toLowerCaseStringArray(Object[] input) {
        return ArrayUtil.transformArray(input, new ToLowercaseStringFunction(), String.class);
    }

    public static String[] toStringArray(Object[] input) {
        return ArrayUtil.transformArray(input, new ToStringFunction(), String.class);
    }

    public static <F, T> T[] transformArray(F[] input, Function<F, T> transformer, Class<T> targetClass) {
        Object[] output = (Object[])Array.newInstance(targetClass, input.length);
        int i = 0;
        while (i < input.length) {
            output[i] = transformer.apply(input[i]);
            ++i;
        }
        return output;
    }

    private static class ToLowercaseStringFunction
    implements Function<Object, String> {
        private ToLowercaseStringFunction() {
        }

        @Override
        public String apply(Object o) {
            return o.toString().toLowerCase(Locale.ENGLISH);
        }
    }

    private static class ToStringFunction
    implements Function<Object, String> {
        private ToStringFunction() {
        }

        @Override
        public String apply(Object o) {
            return o.toString();
        }
    }
}

