/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.instr.tests.naming;

import com.atlassian.clover.api.registry.Annotation;
import com.atlassian.clover.api.registry.AnnotationValue;
import com.atlassian.clover.api.registry.ClassInfo;
import com.atlassian.clover.api.registry.MethodInfo;
import com.atlassian.clover.api.registry.ModifiersInfo;
import com.atlassian.clover.instr.tests.naming.TestNameExtractor;
import com.atlassian.clover.registry.entities.MethodSignature;
import com.atlassian.clover.registry.entities.StringifiedAnnotationValue;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JUnitParameterizedTestExtractor
implements TestNameExtractor {
    private static final String FQN_PARAMETERIZED_CLASS = "org.junit.runners.Parameterized.class";
    private static final String PARAMETERIZED_CLASS = "Parameterized.class";
    private static final String RUN_WITH = "RunWith";
    private static final String FQN_JUPITER_PARAMETERIZED_CLASS = "org.junit.jupiter.params.ParameterizedTest.class";
    private static final String JUPITER_PARAMETERIZED_TEST = "ParameterizedTest";

    @Override
    @Nullable
    public String getTestNameForMethod(@NotNull MethodInfo methodInfo) {
        ClassInfo thisClass = methodInfo.getContainingClass();
        if (thisClass != null && JUnitParameterizedTestExtractor.isParameterizedClass(thisClass.getModifiers())) {
            MethodInfo dataMethod = JUnitParameterizedTestExtractor.findDataMethod(thisClass);
            if (dataMethod != null) {
                return JUnitParameterizedTestExtractor.getParametersNameValue(dataMethod);
            }
        } else if (thisClass != null) {
            return JUnitParameterizedTestExtractor.getJUnit5ParamTestMethodName(methodInfo);
        }
        return null;
    }

    public static boolean isParameterizedClass(ModifiersInfo modifiers) {
        for (Annotation annotation : modifiers.getAnnotation(RUN_WITH)) {
            String className = JUnitParameterizedTestExtractor.getDefaultValue(annotation);
            if (!FQN_PARAMETERIZED_CLASS.equals(className) && !PARAMETERIZED_CLASS.equals(className)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static MethodInfo findDataMethod(ClassInfo classInfo) {
        for (MethodInfo methodInfo : classInfo.getMethods()) {
            long mask = methodInfo.getSignature().getModifiers().getMask();
            if (!methodInfo.getSimpleName().equals("data") || (mask & 1L) == 0L || (mask & 8L) == 0L) continue;
            return methodInfo;
        }
        return null;
    }

    @Nullable
    private static String getDefaultValue(Annotation annotation) {
        AnnotationValue defaultValue = annotation.getAttribute("value");
        if (defaultValue instanceof StringifiedAnnotationValue) {
            return ((StringifiedAnnotationValue)defaultValue).getValue();
        }
        return null;
    }

    @Nullable
    private static String getParametersNameValue(MethodInfo dataMethod) {
        Annotation parameters;
        AnnotationValue nameValue;
        Collection<Annotation> parametersAnno = dataMethod.getSignature().getModifiers().getAnnotation("Parameters");
        if (!parametersAnno.isEmpty() && (nameValue = (parameters = parametersAnno.iterator().next()).getAttribute("name")) instanceof StringifiedAnnotationValue) {
            return ((StringifiedAnnotationValue)nameValue).getValue();
        }
        return null;
    }

    public static boolean isJUnit5ParameterizedTest(@NotNull MethodSignature methodSignature) {
        Map<String, Collection<Annotation>> annotationsMap = methodSignature.getAnnotations();
        return annotationsMap.containsKey(JUPITER_PARAMETERIZED_TEST) || annotationsMap.containsKey("org.junit.jupiter.params.ParameterizedTest");
    }

    @Nullable
    private static String getJUnit5ParamTestMethodName(@NotNull MethodInfo methodInfo) {
        Annotation parameters;
        AnnotationValue nameValue;
        Collection<Annotation> jupiterParameterizedAnnos = methodInfo.getSignature().getModifiers().getAnnotation(JUPITER_PARAMETERIZED_TEST);
        if (jupiterParameterizedAnnos.size() > 0 && (nameValue = (parameters = jupiterParameterizedAnnos.iterator().next()).getAttribute("name")) instanceof StringifiedAnnotationValue) {
            return ((StringifiedAnnotationValue)nameValue).getValue();
        }
        return null;
    }
}

