/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover;

import com.atlassian.clover.CloverLicense;
import com.atlassian.clover.CloverLicenseDecoder;
import com.atlassian.clover.CloverLicenseInfo;
import com.atlassian.clover.LicenseDecoderException;
import com.atlassian.clover.Logger;
import com.atlassian.clover.util.format.ConsoleFormatter;
import org.openclover.util.ClassPathUtil;

public class CloverStartup {
    public static void loadLicense(Logger log) {
        CloverStartup.loadLicense(log, true, 0L);
    }

    public static void loadLicense(Logger log, boolean fail) {
        CloverStartup.loadLicense(log, fail, 0L);
    }

    public static void loadLicense(Logger log, boolean fail, long pluginInstallTs) {
        CloverStartup.logVersionInfo(log);
        try {
            CloverLicense license = CloverLicenseDecoder.decode("");
            CloverLicenseInfo.NAME = license.getLicenseName();
            CloverLicenseInfo.OWNER_STMT = license.getOwnerStatement();
            CloverLicenseInfo.CONTACT_INFO_STMT = license.getContactInfoStatement();
            CloverLicenseInfo.PRE_EXPIRY_STMT = license.getPreExpiryStatement();
            CloverLicenseInfo.POST_EXPIRY_STMT = license.getPostExpiryStatement();
            CloverLicenseInfo.EXPIRED = license.isExpired();
            CloverLicenseInfo.EXPIRES = license.expires();
            CloverLicenseInfo.DAYS_REMAINING = license.getDaysTillExpiry();
            CloverStartup.evaluateDaysLeft(CloverLicenseInfo.DAYS_REMAINING);
            log.debug(ConsoleFormatter.format(CloverLicenseInfo.OWNER_STMT));
        }
        catch (LicenseDecoderException e) {
            log.debug(e);
        }
    }

    public static void logVersionInfo(Logger log) {
        log.info("OpenClover Version 4.5.2, built on 2024-01-31");
        String loadedFrom = ClassPathUtil.getCloverJarPath();
        if (loadedFrom != null) {
            log.debug("Loaded from: " + loadedFrom);
        } else {
            log.debug("Couldn't determine path we were loaded from.");
        }
    }

    public static void setLicenseLoader(LicenseLoader loader) {
        if (loader == null) {
            throw new IllegalArgumentException("CloverStartup does not support a 'null' LicenseLoader.");
        }
    }

    private static void evaluateDaysLeft(long daysLeft) {
        if (daysLeft < 0L) {
            daysLeft = 0L;
        }
        CloverLicenseInfo.PRE_EXPIRY_STMT = CloverLicenseInfo.PRE_EXPIRY_STMT.replaceAll("\\$[dD][aA][yY][sS][lL][eE][fF][tT]", Long.toString(daysLeft));
    }

    public static interface LicenseLoader {
        public static final String LICENSE_FILE_NAME = "clover.license";

        public CloverLicense loadLicense(Logger var1);
    }
}

