/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.util;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.util.zip.Adler32;
import java.util.zip.Checksum;

public class ChecksummingReader
extends FilterReader {
    private Checksum checksum = new Adler32();

    public ChecksummingReader(Reader in) {
        super(in);
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read(char[] chars, int off, int len) throws IOException {
        int i = 0;
        while (i < len) {
            int c = this.read();
            if (c < 0) {
                return i == 0 ? -1 : i;
            }
            chars[i + off] = (char)c;
            ++i;
        }
        return len;
    }

    @Override
    public int read() throws IOException {
        int c = super.read();
        if (c >= 0 && c != 13) {
            this.checksum.update(c >>> 8);
            this.checksum.update(c);
        }
        return c;
    }

    public long getChecksum() {
        return this.checksum.getValue();
    }
}

