/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.instr.java;

import com.atlassian.clover.instr.java.CloverToken;
import java.util.BitSet;

public class ExpressionInfo {
    private boolean constant = false;
    private boolean containsAssign = false;
    private int complexity = 0;
    private static final BitSet CONSTANT_TOKENS = new BitSet();

    static {
        CONSTANT_TOKENS.set(138);
        CONSTANT_TOKENS.set(139);
        CONSTANT_TOKENS.set(140);
        CONSTANT_TOKENS.set(143);
        CONSTANT_TOKENS.set(146);
        CONSTANT_TOKENS.set(147);
        CONSTANT_TOKENS.set(148);
        CONSTANT_TOKENS.set(144);
        CONSTANT_TOKENS.set(145);
        CONSTANT_TOKENS.set(130);
        CONSTANT_TOKENS.set(131);
        CONSTANT_TOKENS.set(132);
        CONSTANT_TOKENS.set(133);
        CONSTANT_TOKENS.set(71);
        CONSTANT_TOKENS.set(124);
        CONSTANT_TOKENS.set(125);
        CONSTANT_TOKENS.set(137);
        CONSTANT_TOKENS.set(121);
        CONSTANT_TOKENS.set(122);
        CONSTANT_TOKENS.set(108);
        CONSTANT_TOKENS.set(86);
        CONSTANT_TOKENS.set(136);
        CONSTANT_TOKENS.set(123);
        CONSTANT_TOKENS.set(77);
        CONSTANT_TOKENS.set(78);
        CONSTANT_TOKENS.set(56);
        CONSTANT_TOKENS.set(93);
        CONSTANT_TOKENS.set(49);
        CONSTANT_TOKENS.set(59);
        CONSTANT_TOKENS.set(55);
        CONSTANT_TOKENS.set(127);
        CONSTANT_TOKENS.set(126);
        CONSTANT_TOKENS.set(129);
        CONSTANT_TOKENS.set(60);
        CONSTANT_TOKENS.set(61);
    }

    public static ExpressionInfo fromTokens(CloverToken start, CloverToken end) {
        ExpressionInfo info = new ExpressionInfo();
        info.constant = true;
        CloverToken t = start;
        while (t.getNext() != end.getNext()) {
            if (!CONSTANT_TOKENS.get(t.getType())) {
                info.constant = false;
                break;
            }
            t = t.getNext();
        }
        if (!info.constant) {
            info.complexity = 1;
            int openParens = 1;
            CloverToken curr = start;
            while (curr != null && openParens > 0 && curr != end) {
                switch (curr.getType()) {
                    case 89: {
                        info.containsAssign = true;
                        break;
                    }
                    case 77: {
                        ++openParens;
                        break;
                    }
                    case 78: {
                        --openParens;
                        break;
                    }
                    case 121: 
                    case 122: {
                        ++info.complexity;
                        break;
                    }
                }
                curr = curr.getNext();
            }
        }
        return info;
    }

    public boolean isConstant() {
        return this.constant;
    }

    public boolean isContainsAssign() {
        return this.containsAssign;
    }

    public boolean isInstrumentable() {
        return !this.constant && !this.containsAssign;
    }

    public int getComplexity() {
        return this.complexity;
    }
}

