/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.util.trie;

import com.atlassian.clover.util.trie.Node;
import com.atlassian.clover.util.trie.NodeFactory;
import com.atlassian.clover.util.trie.NodeImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NodeFactoryImpl
implements NodeFactory {
    public static final NodeFactory HASH_MAP_BACKED = new NodeFactory(){

        @Override
        public <K, V> Node<K, V> createNode(@NotNull K key, @Nullable V value) {
            return new NodeImpl<K, V>(key, value, new HashMap());
        }

        @Override
        public <K, V> Map<K, Node<K, V>> cloneChildren(@NotNull Node<K, V> node) {
            return new HashMap<K, Node<K, V>>(node.children());
        }
    };
    public static final NodeFactory TREE_MAP_BACKED = new NodeFactory(){

        @Override
        public <K, V> Node<K, V> createNode(@NotNull K key, @Nullable V value) {
            return new NodeImpl<K, V>(key, value, new TreeMap());
        }

        @Override
        public <K, V> Map<K, Node<K, V>> cloneChildren(@NotNull Node<K, V> node) {
            return new TreeMap<K, Node<K, V>>(node.children());
        }
    };
}

