/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.util;

import com.atlassian.clover.Logger;
import com.atlassian.clover.api.registry.MethodInfo;
import com.atlassian.clover.api.registry.PackageInfo;
import com.atlassian.clover.optimization.Snapshot;
import com.atlassian.clover.registry.entities.FullFileInfo;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openclover.util.Sets;

public class CloverUtils {
    private static final Object FILE_SYSTEM_LOCK = new Object();
    public static final String SYNTH_TESTNAME_PREF = "__CLR4_5_0";
    private static final HashSet<String> IGNORE_TRACE_LINES = Sets.newHashSet("sun.reflect.NativeMethodAccessorImpl.invoke", "sun.reflect.DelegatingMethodAccessorImpl.invoke", "sun.reflect.NativeMethodAccessorImpl.invoke0", "java.lang.reflect.Method.invoke", "junit.framework.Assert.assertEquals", "junit.framework.TestCase.runTest", "junit.framework.TestCase.runBare", "junit.framework.TestResult$1.protect", "junit.framework.TestResult.runProtected", "junit.framework.TestResult.run", "junit.framework.TestCase.run", "junit.framework.TestSuite.runTest", "junit.framework.TestSuite.run", "org.apache.tools.ant.taskdefs.optional.junit.JUnitTestRunner.run", "org.apache.tools.ant.taskdefs.optional.junit.JUnitTestRunner.launch", "org.apache.tools.ant.taskdefs.optional.junit.JUnitTestRunner.main");

    public static boolean scrubCoverageData(String initString, boolean deleteDatabase) {
        return CloverUtils.scrubCoverageData(initString, deleteDatabase, false, false);
    }

    public static boolean scrubCoverageData(String initString, boolean deleteDatabase, boolean deleteSnapshot, boolean verbose) {
        String testSnapshotName;
        String baseName;
        String[] fileNames;
        if (initString == null) {
            return false;
        }
        File cloverDb = new File(initString);
        File cloverDbDir = cloverDb.getParentFile();
        if (cloverDbDir != null && cloverDbDir.exists() && cloverDbDir.isDirectory() && (fileNames = cloverDbDir.list(new FilenameFilter(baseName = cloverDb.getName(), deleteDatabase, testSnapshotName = Snapshot.fileNameForInitString(baseName), deleteSnapshot){
            private final /* synthetic */ String val$baseName;
            private final /* synthetic */ boolean val$deleteDatabase;
            private final /* synthetic */ String val$testSnapshotName;
            private final /* synthetic */ boolean val$deleteSnapshot;
            {
                this.val$baseName = string;
                this.val$deleteDatabase = bl;
                this.val$testSnapshotName = string2;
                this.val$deleteSnapshot = bl2;
            }

            @Override
            public boolean accept(File dir, String name) {
                if (this.val$baseName.equals(name)) {
                    return this.val$deleteDatabase;
                }
                if (this.val$testSnapshotName.equals(name)) {
                    return this.val$deleteSnapshot;
                }
                return name.startsWith(this.val$baseName);
            }
        })) != null && fileNames.length > 0) {
            String[] stringArray = fileNames;
            int n = fileNames.length;
            int n2 = 0;
            while (n2 < n) {
                String fileName = stringArray[n2];
                File covFile = new File(cloverDbDir, fileName);
                if (covFile.exists() && !covFile.isDirectory()) {
                    if (verbose) {
                        Logger.getInstance().info("Deleting " + covFile.getAbsolutePath());
                    }
                    if (!covFile.delete()) {
                        Logger.getInstance().warn("Unable to delete " + covFile.getAbsolutePath());
                        return false;
                    }
                }
                ++n2;
            }
        }
        return true;
    }

    public static String cloverizeClassName(String className) {
        return className == null ? className : className.replace('$', '.').replaceAll("\\.[0-9]+", "");
    }

    public static File createOutFile(FullFileInfo finfo, String outname, File baseDir) throws IOException {
        PackageInfo pkg = finfo.getContainingPackage();
        File outdir = CloverUtils.createOutDir(pkg, baseDir);
        return new File(outdir, outname);
    }

    public static File createOutDir(PackageInfo pkg, File basePath) throws IOException {
        File outdir = new File(basePath, pkg.isDefault() ? pkg.getName() : pkg.getPath());
        CloverUtils.createDir(outdir);
        return outdir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createDir(File outdir) throws IOException {
        Object object = FILE_SYSTEM_LOCK;
        synchronized (object) {
            if (!outdir.mkdirs() && !outdir.isDirectory()) {
                throw new IOException("Failed to create directory " + outdir);
            }
        }
    }

    public static void logDeprecationWarning(String name) {
        Logger.getInstance().warn("WARNING: The " + name + " is deprecated. It will be ignored.");
    }

    public static String createSyntheticTestName(MethodInfo method) {
        return SYNTH_TESTNAME_PREF + Long.toString(Math.abs(method.getName().hashCode()), 36) + Integer.toString(method.getDataIndex(), 36);
    }

    public static String transformStackTrace(String trace, boolean filterTrace) {
        if (trace == null) {
            return null;
        }
        Pattern synthPattern = Pattern.compile(SYNTH_TESTNAME_PREF);
        Pattern filePattern = Pattern.compile("(\\(.*\\))");
        StringBuilder buff = new StringBuilder();
        LineNumberReader reader = new LineNumberReader(new StringReader(trace));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                Matcher synthMatcher = synthPattern.matcher(line);
                if (synthMatcher.find()) {
                    Matcher fileMatcher = filePattern.matcher(line);
                    if (fileMatcher.find()) {
                        String filePart = fileMatcher.group(1);
                        String nextLine = reader.readLine();
                        if (nextLine == null) {
                            buff.append(line);
                            return buff.toString();
                        }
                        Matcher nextMatcher = filePattern.matcher(nextLine);
                        if (nextMatcher.find()) {
                            buff.append(nextLine.subSequence(0, nextMatcher.start()));
                            buff.append(filePart);
                            buff.append('\n');
                            continue;
                        }
                        buff.append(line);
                        buff.append('\n');
                        buff.append(nextLine);
                        buff.append('\n');
                        continue;
                    }
                    buff.append(line);
                    buff.append('\n');
                    continue;
                }
                if (filterTrace) {
                    String fqmn;
                    int firstSpace = line.indexOf(" ");
                    int openParen = line.indexOf("(");
                    if (firstSpace >= 0 && openParen >= 0 && firstSpace < openParen && IGNORE_TRACE_LINES.contains(fqmn = line.substring(firstSpace + 1, openParen))) continue;
                }
                buff.append(line);
                buff.append('\n');
            }
        }
        catch (IOException e) {
            Logger.getInstance().error(String.valueOf(e.getMessage()) + " reading stack trace: " + trace);
        }
        return buff.toString().trim();
    }

    public static String packageNameToPath(String name, boolean isDefaultPkg) {
        String workingPath = "";
        if (!isDefaultPkg && name.length() > 0) {
            workingPath = String.valueOf(name.replace('.', '/')) + '/';
        }
        return workingPath;
    }
}

