/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.cfg.instr.java;

import com.atlassian.clover.cfg.instr.java.LanguageFeature;
import com.atlassian.clover.util.JavaEnvUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.openclover.util.Sets;

public enum SourceLevel {
    JAVA_7("1.7", Sets.newHashSet("1.7", "7"), Collections.emptySet()),
    JAVA_8("1.8", Sets.newHashSet("1.8", "8"), Collections.singleton(LanguageFeature.LAMBDA)),
    JAVA_9("9", Sets.newHashSet("1.9", "9"), Sets.newHashSet(LanguageFeature.LAMBDA, LanguageFeature.MODULES)),
    JAVA_10("10", Sets.newHashSet("1.10", "10"), Sets.newHashSet(LanguageFeature.LAMBDA, LanguageFeature.MODULES)),
    JAVA_11("11", Sets.newHashSet("1.11", "11"), Sets.newHashSet(LanguageFeature.LAMBDA, LanguageFeature.MODULES));

    private static final Set<String> unsupportedSourceLevels;
    private final String primaryVersionString;
    private final HashSet<String> versionStrings;
    private final Set<LanguageFeature> languageFeatures;

    static {
        unsupportedSourceLevels = Sets.newHashSet("1.0", "1.1", "1.2", "1.3", "1.4", "1.5", "5", "1.6", "6");
    }

    private SourceLevel(String primaryVersionString, HashSet<String> versionStrings, Set<LanguageFeature> languageFeatures) {
        this.primaryVersionString = primaryVersionString;
        this.versionStrings = versionStrings;
        this.languageFeatures = languageFeatures;
    }

    public static SourceLevel fromString(@NotNull String source) {
        if (JAVA_11.matchesVersion(source)) {
            return JAVA_11;
        }
        if (JAVA_10.matchesVersion(source)) {
            return JAVA_10;
        }
        if (JAVA_9.matchesVersion(source)) {
            return JAVA_9;
        }
        if (JAVA_8.matchesVersion(source)) {
            return JAVA_8;
        }
        return JAVA_7;
    }

    public static SourceLevel autoDetect() {
        return SourceLevel.fromString(JavaEnvUtils.getJavaVersion());
    }

    public static boolean isUnsupported(@NotNull String source) {
        return unsupportedSourceLevels.contains(source);
    }

    public static String getUnsupportedMessage(@NotNull String source) {
        return String.format("Source level '%s' is unsupported, assuming '%s'.", source, JAVA_7.asString());
    }

    public boolean supportsFeature(LanguageFeature feature) {
        return this.languageFeatures.contains((Object)feature);
    }

    public boolean matchesVersion(String version) {
        return this.versionStrings.contains(version);
    }

    public String asString() {
        return this.primaryVersionString;
    }
}

